from bcc import BPF

# BPF Program to attach to the handshake function
bpf_program = """
#include <linux/sched.h>
#include <net/sock.h>

// Define a data structure to pass handshake events to user space
struct handshake_event {
    char peer[64]; // Peer identifier (simplified)
    u64 timestamp; // Timestamp of the handshake
};

BPF_PERF_OUTPUT(events);

// Probe the WireGuard handshake function
int trace_wg_handshake(struct pt_regs *ctx, struct sock *sk) {
    struct handshake_event evt = {};

    // Simplified logic to get handshake details
    bpf_get_current_comm(&evt.peer, sizeof(evt.peer));
    evt.timestamp = bpf_ktime_get_ns();

    events.perf_submit(ctx, &evt, sizeof(evt));
    return 0;
}
"""

# Load the BPF program
bpf = BPF(text=bpf_program)

# Attach the probe to the WireGuard handshake kernel function
bpf.attach_kprobe(event="wg_handshake", fn_name="trace_wg_handshake")

# Print output
def print_event(cpu, data, size):
    event = bpf["events"].event(data)
    print(f"Handshake detected with peer: {event.peer}, Timestamp: {event.timestamp}")

bpf["events"].open_perf_buffer(print_event)

print("Monitoring WireGuard handshakes...")
while True:
    try:
        bpf.perf_buffer_poll()
    except KeyboardInterrupt:
        exit()

