# coding: utf-8
# To install the library, run the following
#
# python setup.py install
#
# prerequisite: setuptools
# http://pypi.python.org/pypi/setuptools

"""
    Cohesive Networks SDK

    Cohesive Networks SDK is a thin wrapper around our product APIs providing complete control of your network's addresses, routes, rules and edge  # noqa: E501

    The version of the OpenAPI document: 4.8
    Contact: solutions@cohesive.net
    Generated by: https://openapi-generator.tech
"""

import os
import sys
from setuptools import setup, find_packages  # noqa: H301
from setuptools.command.test import test as TestCommand

LIB_NAME = "cnvpnclient"
DEPENDENCIES = ["requests==2.32.3", 
                 "idna==3.10",
                 "requests-toolbelt==1.0.0",
                 "PyYAML==6.0.2",
                 "psutil==6.0.0"]

DIR = os.path.abspath(os.path.dirname(__file__))


class PyTest(TestCommand):
    user_options = [("pytest-args=", "a", "Arguments to pass to pytest")]

    def initialize_options(self):
        TestCommand.initialize_options(self)
        self.pytest_args = "--tb=short"

    def run_tests(self):
        import shlex

        # import here, cause outside the eggs aren't loaded
        import pytest

        errno = pytest.main(shlex.split(self.pytest_args))
        sys.exit(errno)


os.chdir(DIR)

version_contents = {}
with open(os.path.join(DIR, LIB_NAME, "version.py"), encoding="utf-8") as f:
    exec(f.read(), version_contents)


def load_long_description():
    with open(os.path.join(DIR, "README.public.md"), "r") as fh:
        return fh.read()


setup(
    name=LIB_NAME,
    version=version_contents["VERSION"],
    description="Cohesive Networks VPN Client SDK/CLI",
    options={"bdist_wheel": {"universal": True}},
    author="Cohesive Networks, Inc.",
    long_description=load_long_description(),
    long_description_content_type="text/markdown",
    author_email="solutions@cohesive.net",
    python_requires=">=3.5.0",
    scripts=["%s/bin/cnvpn" % LIB_NAME, "%s/scripts/wg-quick.darwin.bash" % LIB_NAME],
    url="https://github.com/cohesive/cohesive-wg-utils",
    keywords=[
        "Cohesive Networks VPN",
        "Cohesive Networks",
        "Secops",
        "SDN",
        "Software Defined Networking",
        "Networkops",
        "networking",
        "SASE",
        "Openapi",
    ],
    install_requires=DEPENDENCIES,
    tests_require=[
        "pytest >= 4.6.2",
        "pytest-mock >= 1.10.4",
        "pytest-xdist >= 1.28.0",
        "pytest-cov >= 2.7.1",
    ],
    packages=find_packages(exclude=["tests", "docs", "examples", "data"]),
    package_dir={"cnvpnclient": "cnvpnclient"},
    include_package_data=True,
    package_data={LIB_NAME: ["version", "scripts/*.bash", "BUILDNUMBER"]},
    cmdclass={"test": PyTest},
    license="MIT",
    classifiers=[
        "Development Status :: 3 - Alpha",
        "Intended Audience :: Developers",
        "Topic :: System :: Networking",
        "Topic :: System :: Networking :: Firewalls",
        "Topic :: System :: Networking :: VPN",
        "Topic :: Security",
        "License :: OSI Approved :: MIT License",
        "Programming Language :: Python",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.8",
    ],
)
