import os

from cnvpnclient.exception import ClientException

PERMISSION_ERR_TEMPL = "Invalid permissions for %s. If initially run as admin/root or a different user, the state file permissions won't allow access."


def lines_to_dict(file_lines):
    data = {}
    for line in file_lines:
        line_parts = [part.strip() for part in line.strip().split(":")]
        key = line_parts[0].lower()
        if not key:
            continue
        value = ":".join(line_parts[1:])
        data[key] = value
    return data


def dict_to_lines(data):
    return "\n".join(["%s:%s" % (key, val) for key, val in data.items()])


def parse_data_file(data_file_path):
    if not os.path.exists(data_file_path):
        return None

    try:
        with open(data_file_path, "r") as conn_file_desc:
            file_data = conn_file_desc.read()
            file_lines = file_data.split("\n")
        return lines_to_dict(file_lines)
    except PermissionError:
        raise ClientException(PERMISSION_ERR_TEMPL % data_file_path)


def put_data_file(data_file_path, data):
    try:
        file_content = dict_to_lines(data)
        with open(data_file_path, "w") as file_desc:
            file_desc.write(file_content)
            file_desc.flush()
    except PermissionError:
        raise ClientException(PERMISSION_ERR_TEMPL % data_file_path)
    return True


def update_data_file(data_file_path, data=None, remove_keys=None):
    final_data = {}
    try:
        with open(data_file_path, "r+") as fd:
            prev_data = lines_to_dict(fd.read().split("\n"))
            final_data.update(prev_data)
            if remove_keys:
                [final_data.pop(k, None) for k in remove_keys]
            final_data.update((data or {}))
            fd.seek(0)
            fcontent = dict_to_lines(final_data)
            fd.write(fcontent)
            fd.truncate()
            fd.flush()
        return final_data
    except PermissionError:
        raise ClientException(PERMISSION_ERR_TEMPL % data_file_path)


def put_key_value(file_path, key, val):
    new_data = {}
    new_data[key] = val
    return update_data_file(file_path, new_data)


def remove_key(file_path, key):
    return update_data_file(file_path, remove_keys=[key])


def remove_file(file_path):
    if os.path.exists(file_path):
        os.remove(file_path)
        return True
    return False
