# cohesive-wg-utils

## Installation
The latest build can be found on the [docs page](https://docs.cohesive.net/docs/vns3/vpn-client/#installation) for the client and client app.

You can install with pip by `pip install [url to package]`

Or you can clone the repo and run it locally.

**Note on VNS3 version support**

- v0 - v0.1.2 requires VNS3 version 6.0
- v1 - requires VNS3 version 6.1 or above

## cnvpnclient library
The code has been reorganized into modules

- `api.py` - main python interface for interacting with VPN clients. view, create, start, stop, and delete connections.
- `client.py` - main functions for running the cohesive vpn process
- `config.py` - module for capturing config from env and defining default constants
- `files.py` - utils for interacting with local files as app datastore
- `logutil.py` - utils for logging
- `version.py` - current package version

## API

```
from cnvpnclient import api as vpn

# main functions

# Stop connection with name and clientpack
vpn.start_connection
# Stop connection by name
vpn.stop_connection
# List all connections (stored in files in data/ directory)
vpn.list_connections
# Delete connection
vpn.delete_connection

# This is a blocking method that will start the vpn client. Typically
# you will call start_connection to manage the connection
vpn.run_connection
```

## Configuration
The lib/cli configuration is defined and read from env by `config.py`:

**LibConfig** class

This contains constants that won't change related to the file naming conventions and local file system storage locations for state and logs

**EnvConfig** class

This contains configuration values that can be overriden by enviornment variables. The environment variables should have the prefix `CNVPN_`. The configuration values are

```
[Required]
WG_DIR - path to directory to store clientpack conf files in. OR use "local" for local to data dir. Common use would be to point at the standard install directory for your platform, e.g. /etc/wireguard/
[Optional]
DATA_DIR=/my/data - Where to store connection data. Default: [User home]/.cohesive (~/.cohesive)
WG_AUTH: default auth. oidc
AUTO_DISCOVER_INTERFACE: (True/False) default: False. If true, start_connection will calculate the next available interface for a clientpack
ALLOW_CUSTOM_INTERFACE: (True/False) default: False. If true, allow a non-wgX name for
the interface, as taken from the clientpack name. e.g. mycustominterface.conf
POLLING_INTERVAL: how often to poll for new routes. default 30
LOGIN_RETRY_INTERVAL: how often to poll for login success if auth enabled. default 3.
LOG_LEVEL: default INFO
WG_PATH: default is 'wg' (unless bundled or windows). That is, it assumes wg is in path. Can also provide full path to wg executable
WG_QUICK_PATH: default is 'wg-quick' (unless bundled or windows). That is, it assumes wg-quick is in path. Can also provide full path to wg-quick executable.
```

**Setting environment variables in powershell**

```
$Env:CNVPN_LOG_LEVEL = 'DEBUG'
```

**Note on clientpack discovery**

If the clientpack passed is not a path to a clientpack but is instead the name of the file in the configured WG_DIR, then that clientpack will be used (provided it is not already taken by another client).

Examples:
```
$ export CNVPN_WG_DIR=/etc/wireguard/
$ ls /etc/wireguard
wg1.conf
$ cnvpn start --clientpack wg1 --name tunnel1
```

**Note on interface configuration and discovery logic**

There are 3 different ways to configure how cnvpnclient determines the interface:

1. The name of the clientpack file. e.g. wg1.conf 
2. If `CNVPN_ALLOW_CUSTOM_INTERFACE` is True, use custom name from clientpack name. e.g. customint.conf
3. If `CNVPN_AUTO_DISCOVER_INTERFACE` is True, then even if there are conflicts from 1 or 2, calculate the next available wireguard standard interface, ie. wg[integer], e.g. wg3

Examples:
```
CNVPN_ALLOW_CUSTOM_INTERFACE=False CNVPN_AUTO_DISCOVER_INTERFACE=False cnvpn start -n test -cp 100_64_0_1.conf
Result: Invalid interface 100_64_0_1

CNVPN_ALLOW_CUSTOM_INTERFACE=True CNVPN_AUTO_DISCOVER_INTERFACE=False cnvpn start -n test -cp 100_64_0_1.conf
Result: Tries to create interface with name 100_64_0_1. If taken, it fails.

CNVPN_ALLOW_CUSTOM_INTERFACE=False CNVPN_AUTO_DISCOVER_INTERFACE=True cnvpn start -n test -cp 100_64_0_1.conf
Result: Calculates next wireguard interface. e.g. wg1, wg2 etc.

# wg0 is taken
CNVPN_ALLOW_CUSTOM_INTERFACE=False CNVPN_AUTO_DISCOVER_INTERFACE=True cnvpn start -n test -cp wg0.conf
Result: Calculates next wireguard interface. e.g. wg1

# test is taken
CNVPN_ALLOW_CUSTOM_INTERFACE=True CNVPN_AUTO_DISCOVER_INTERFACE=True cnvpn start -n test -cp test.conf
Result: Calculates next wireguard interface because interface "test" is taken. e.g. wg3
```

## CLI
```
# show help
$bin/cnvpn --help
usage: cnvpn [-h|--help] [--log-level LOG_LEVEL] [-c/-cp clientpack.conf] [-n name] action

Command line interface for VNS3 VPN Client

positional arguments:
  action                API object action to execute

optional arguments:
  -h, --help            show this help message and exit
  -c CLIENTPACK, -cp CLIENTPACK, --clientpack CLIENTPACK
                        Clientpack file
  -n NAME, --name NAME  Connection name
  --log-level LOG_LEVEL
  --names NAMES [NAMES ...]
                        filter by clientpack names
  --details             Show full details of connections
  --verbose             Show verbose output

Examples:
$ bin/cnvpn start -cp/--clientpack clientpack.conf -n/--name [connection name]
$ bin/cnvpn stop -n/--name [connection name]
$ bin/cnvpn delete -n/--name [connection name]
$ bin/cnvpn show-connection -n/--name [connection name]
$ bin/cnvpn list-connections [-n/--names [name1] [name2]]

Environment variables:
CNVPN_WG_DIR=/path/to/wireguard/ OR 'local' - Where to store wireguard confs. If local, will store in local data directory.
CNVPN_AUTO_DISCOVER_INTERFACE=(False/True) - calculate next available wg interface. e.g. 100_64_0_1.conf => wg2
CNVPN_ALLOW_CUSTOM_INTERFACE=(False/True) - allow custom interface name parsed from clientpack file name. e.g. test.conf => test
CNVPN_LOG_LEVEL=(ERROR/WARN/INFO/DEBUG) - default INFO
CNVPN_WINDOWS_WIREGUARD_EXE=/path/to/wireguard.exe. default='C:\Program Files\WireGuard\wireguard.exe'
```

## Local data storage
The default data storage location depends on the Operating System but can also be configured with a environment variable. Default locations:
- Default windows location: [User Home]\AppData\Local\Cohesive
- Default mac location: [User Home]\.cohesive

### Main state file

**connection state files**: `data/connection.[name_of_connection]`

### Other Connection data
These files are pointed at in the state file. e.g. `routes_file: /path/to/data/routes.[name]`

**connection route files**: `data/routes.[name_of_connection]`

state file key: `routes_file`

**connection log files with rotation**: `data/logs/connection.[name_of_connection].log`

state file key: `log_file`

## Build and Distribution
Latest builds are linked @ https://docs.cohesive.net/docs/vns3/vpn-client and artifacts should be uploaded to cohesive serving location

**Build** - `make build`- output a tar.gz file to `dist/` directory 
**Format python with black** - `make fmt`
**Upload to AWS S3 Bucket** - `(AWS_PROFILE=production) make upload` (optionally point to correct AWS profile)

### Building a standalone Executable for Mac
1. On Mac, install the packaging dependencies defined in `requirements.pkg.mac.txt`. I recommend installnig in a python virtualenv or some contained env.
2. Run package.mac.sh script. The standandalone executable can optionally include Wireguard bundled inside or not. Every release should build both options. That is, a release of the client should include 2 builds for the OS targeted: 1 with wireguard bundled and 1 without wireguard bundled
3. Artifacts will be outputed to temp/ dir

```
source .env/bin/activate # activate python virtualenv
# run with sudo/root permissions
./package.mac.sh --help # show script help
./package.mac.sh --with-wg # bundle in wireguard
./package.mac.sh --upload # dont bundle in wireguard, upload to s3
```

Packaging outputs zip to ./temp directory

Pyinstaller Notes:
- we have to run this on both an intel based Mac and M1/2-based Mac's as pyinstaller uses the underlying OS architecture. So we will have 4 builds for Mac: for each OS architecture (intel and m1) there will be a with wireguard bundled and without wireguard bundled version
- The build should also be run on the "oldest" OS we have available to us and are willing to support. Pyinstaller is forward compatible meaning if we build for MacOS 11 then the build will work for all MacOS after 11, whereas if we build on 12, MacOS 11 wont be supported

[Check this if running python with Pyenv](https://pyinstaller.org/en/stable/development/venv.html?highlight=virtualenv)

### Building a standalone Executable for Windows
Currently building standalone exe for Windows has only been tested on Windows10 Pro.

1. Install python3.8 or python3.9. This will likely add a "py" python exe to your path in powershell.
2. If you dont have the repo on the machine, you can download and unzip the tar.gz created from "make build" step. untar/zip into a directory.
3. Create a python virtualenv. The first time this is set up you can run `py -m pip install virtualenv` to install virtualenv package for the global python installed in step 1
4. Activate the env with `./env/Scripts/activate`
5. `pip install -r requirements.pkg.win.txt` inside the virtualenv
6. Run the packaging script package.win.ps1

```
# needs path to src from step 2
./package.win.ps1 -src "cnvpnclient-1.0.0"
```

A zip file will be created in a folder called either `cnvpn-[version]-py-wg` or `cnvpn-[version]-py` depending on if wireguard is bundled in or not. These dirs will contain zip files that contain the bundled executables. 

*Note* there is currently an issue with bundling wireguard as the windows wireguard installation expects to be installed in a specific location on Windows. So for now only use `-withwg $False`, which is the default. The only real option is to use InnoSetup to create an installer executable like we do for the [vpn app](https://github.com/cohesive/cohesive-vpn-client-app).

These zips are the final artifacts and can be uploaded to download location.
